Option autorun ON

SetPin 2, DOUT      ' MCLR, connect to pin 1 on target
SetPin 3, DOUT      ' TMS, connect to pin 14 and 22 on target
SetPin 4, DOUT      ' TDI, connect to pin 16 on target
SetPin 5, DIN       ' TDO, connect to pin 18 on target
SetPin 6, DOUT      ' CLK, connect to pin 17 on target
SetPin 7, DOUT      ' status LED (via 1k resistor to ground)

Pin(2) = 0
Pin(6) = 0


' the following code needs to be fast

start:
  B = Asc(Inkey$)
  If (B = 0) GoTo start
  If (B > &h40) Then
    Port(3,2) = (B And 3)
    Pin(6) = 1
    If (B < &h60) Then Print Chr$(&h30 + Pin(5));
    Pin(6) = 0
    GoTo start
  EndIf


' the following code can be slow

  If B = Asc("2") Then
    Port(3,2) = 0  ' set TDI and TMS low
    Pause 2
    Pin(2) = 0     ' set MCLR low (target in reset)
  EndIf

  If B = Asc("3") Then
    Port(3,2) = 0  ' set TDI and TMS low
    Pause 2
    Pin(2) = 1     ' set MCLR high (target running)
  EndIf

  If B = Asc("4") Then Pin(7) = 0    ' turn off LED
  If B = Asc("5") Then Pin(7) = 1    ' turn on LED
  If B = Asc("9") Then Print "#";    ' generate handshake
  If B = &h1B Then End               ' exit upon escape being pressed
GoTo start
